function sigma_breve_j = fault_slip_sigma_breve_cheb(ddelta_dy_hat,cheb_terms,G,nu,T,...
    y_bound,y_bound_cross,y_j)
%
% Computes the induced shear stresses sigma_breve in points y (y_minus < y < y_plus)
% resulting from a given slip gradient in other points y (y_minus_cross < y < y_plus_cross).
% The slip gradient is expanded in first-kind Chebyshev polynomials T_n with coefficients d_n
% and weight factor 1/sqrt(1-z_hat^2) over the expanded scaled interval -1 < z_hat < 1
% which covers BOTH slip patches plus the interval in-between: y_tilde_1 < y < y_tilde_4.
%
A = G / (2*pi*(1-nu));
y_minus = y_bound(1);
y_plus = y_bound(2);
y_minus_cross = y_bound_cross(1);
y_plus_cross = y_bound_cross(2);
y_tilde_1 = min(y_minus,y_minus_cross);
y_tilde_4 = max(y_plus,y_plus_cross);
N = cheb_terms;
y_barbar_hat = (y_tilde_1+y_tilde_4)/2;
Delta_y_hat = y_tilde_4-y_tilde_1;
z_j = 2*(y_j-y_barbar_hat)/Delta_y_hat; 
U = fault_slip_cheb_matrix_U(N,N,6,z_j); % U = M x N matrix with second-kind Chebyshev ...
    % polynomials as columns, discretized at points z_j 
d_n = fault_slip_cheb_coeff_delta(ddelta_dy_hat,N,T,y_minus_cross,y_plus_cross);
sigma_breve_j = -pi * A * (U(:,1:end-1)*d_n(2:end))'; 

% % plot(y_j,sigma_breve_j)
% % pause(0.02)
